/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay - USPI Touch Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*          P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2013-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <dipo_plugin.h>
#include <adit_logging.h>
#include "UspiTouchInput.h"

LOG_DECLARE_CONTEXT(cplay_utouch);

using namespace adit::carplay;

extern "C" void carplay_LibraryEntryPoint()
{
    // register uspi-touch at logging
    LOG_REGISTER_CONTEXT(cplay_utouch, "UINP", "CarPlay USPI touch input");

    LOGD_DEBUG((cplay_utouch, "carplay-uspi-touch git tag: %s", COMP_GIT_VERSION));
    carplay_FactoryRegister<IInputAdapter, UspiTouchInput>("UspiTouchInput");
}

extern "C" void carplay_LibraryExitPoint()
{
    LOG_UNREGISTER_CONTEXT(cplay_utouch);
}
